cd "$outpath"

global cond_candi NAF_labex_candidate == 1 & ZE_labex_candidate == 1
global cond_accept NAF_labex_accept == 1 & ZE_labex_accept == 1

/* __________________________________________________________________________
   ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯ 
   1 ** CZ x naf level statistics
   __________________________________________________________________________
   ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯ */ 

global sample_select inrange(year,2004,2019)
use if $sample_select using "${tmp}/Regfile_nafZE", clear

gen has_newcifre = (nb_newcifre > 0)
gen has_transfer_senior = (nbheur_seniorrespubtopri > 35) if inrange(year,2010,2017)
gen has_transfer_junior = (nbheur_respubtopri - nbheur_seniorrespubtopri > 35) if inrange(year,2010,2017)
gen has_transfer_res = (nbheur_respubtopri > 35) if inrange(year,2010,2017)

gen has_soustrait = (soustrait_pub_max_gf > 0 & !mi(soustrait_pub_max_gf)) if inrange(year,2008,2018) 
gen ln_amt_jdoc_max_gf = ln(amt_jdoc_max_gf)
gen ln_soustrait_pub_max_gf = ln(soustrait_pub_max_gf)

gen wagebill_eng = job_eng_sbrut /1e6
gen ln_job_eng_sbrut = ln(job_eng_sbr)

egen tot_hrs = rowtotal(job_eng_hrs job_tech_hrs job_hskill_noneng_hrs other_hrs)

** -- generate dummy if gp is in baseline estimation sample
** -- focus desriptive statistics on estimation sample
reghdfe ln_job_eng_sbrut E_????  if $cond_accept, a(ZE2010#year gp)  cl(gp)
bys gp: egen insampeng = max(e(sample))
keep if insampeng == 1
** -----------------------------------------------------------
	
gen job_tot_fte 	= tot_hrs  	/ (151*12)
gen job_eng_fte 	= job_eng_hrs  	/ (151*12)

recode nb_siren* job_tot_fte job_eng_fte   (.=0)

bys gp: egen dum_pubtopri = sum(nbheur_seniorrespubtopri > 0  & inrange(year,2009,2010) & !mi(nbheur_seniorrespubtopri))
replace dum_pubtopri = dum_pubtopri >0

gen ln1exposure = ln(exposure+1)

*replace exposure = . if  (exposure> 500e+6 & !mi(exposure)) //exposure == 0 |
replace exposure = exposure / 1e+6
replace ln1exposure = 0 if mi(ln1exposure)

label var job_tot_fte 					"Total employment"
label var wagebill_eng 					"Engineer wage bill (in millions euros)"
label var job_eng_fte 					"Engineer employment"
label var ln_job_eng_sbrut				"Log Engineer wage bill (in euros) "

label var nb_siren 						"\# plants "
label var nb_siren_eng					"\# plants employing engineers  "
label var exposure						" Indirect subsidy (in million euros)"
label var ln1exposure					" $ \ln(\text{expo}_{ik} +1) $ "
label var prox							" Proximity "


**-- varlist for stats at the CZ x naf level
global lvar_zenaf exposure ln1exposure prox job_tot_fte job_eng_fte wagebill_eng ln_job_eng_sbrut has_soustrait has_newcifre has_jeu has_jdoc dum_pubtopri nb_siren nb_siren_eng

global mean 
global p50

foreach v in $lvar_zenaf {
	global mean $mean m_`v' = `v'
}

global stat_list p50 p90 

foreach stat in $stat_list {
	global `stat'
	foreach v in $lvar_zenaf {
		global `stat'  $`stat' `stat'_`v' = `v'
	}
}

global cmd_allstat (mean) $mean
foreach stat in $stat_list {
	global cmd_allstat $cmd_allstat (`stat') ${`stat'}
}

macro list cmd_allstat

cd "$intpath"
*preserve 

bys gp: gen distinct_gp = _n==1

gcollapse $cmd_allstat (sum) distinct_gp (count) N = gp if $cond_candi
gen sample = 2

save "${tmp}/stat_all", replace

*restore 
use "${tmp}/stat_all", clear
** -- label of variable included in the table 
global job_tot_fte 					"Total employment"
global job_eng_fte 					"Engineer employment"
global wagebill_eng 				"Engineer wage bill (in millions euros)"
global ln_job_eng_sbrut				"Log Engineer wage bill (in euros) "
*global nbheur_tot_rd20_fte			"Employment in R\&D intensive plants"
*global creance_split				"R&D tax credit claims (in millions euros)"
global has_soustrait				"Has R\&D outsourcing to public sector"
global has_newcifre 				"Has a industry-univ. PhD convention"		
*global pat_nonorm					"\# EPO patents"
global has_jdoc						"Has PhD graduate in priv. sector"
global has_jeu						"Has academic spin-off"
global dum_pubtopri  				"Transfer from univ to private"
global nb_siren 					"\# plants "
global nb_siren_eng					"\# plants employing engineers  "
global exposure						" Indirect subsidy (in million euros)"
global ln1exposure					" $ \ln(\text{expo}_{ik} +1) $ "
global ln1exposure					" Exposure "
global prox							" Proximity "


global N      		  				"Observations"

use "$tmp\stat_all", clear

foreach var in $lvar_zenaf {
	global m_`var'_zn : di %9.2f m_`var'[1]
	foreach stat in $stat_list {
		global `stat'_`var'_zn  : di %9.2f `stat'_`var'[1]
	}
}


global N_zn : dis %12.0gc N[1]
global uniq_zn : dis %12.0gc distinct_gp[1]
global uniq_zn_lab "\# (CZ $\times$ NAF) "	


global lvar_zenaf_job 	  exposure ln1exposure prox job_tot_fte job_eng_fte wagebill_eng ln_job_eng_sbrut  nbheur_tot_rd20_fte nb_siren 




/* __________________________________________________________________________
   ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯ 
   2 ** -- variable at the ZE level 
   __________________________________________________________________________
   ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯ */ 

use if $sample_select using "${tmp}/Regfile_nafZE", clear

gen ln_job_eng_sbrut = ln(job_eng_sbrut)
egen tot_hrs = rowtotal(job_eng_hrs job_tech_hrs job_hskill_noneng_hrs other_hrs)
gen tot_hrs_fte 	= tot_hrs  	/ (151*12)
gen job_eng_fte 	= job_eng_hrs  	/ (151*12)
gen wagebill_eng 	= job_eng_sbrut /1e6

** -- generate dummy if gp is in baseline estimation sample
reghdfe ln_job_eng_sbrut E_????  if $cond_accept, a(ZE2010#year gp)  cl(gp)
bys gp: egen insampeng = max(e(sample))
keep if insampeng == 1


bys ZE2010: egen tag = sum($cond_candi)
keep if tag>0

bys ZE2010 ape year: gen nb_sector_ze = _n==1

rename tot_hrs_fte tot_hrs_fte_ze

global zevar nb_sector_ze tot_hrs_fte_ze nb_siren nb_siren_eng

global 	nb_sector_ze "\# of 5-digit sector"
global 	tot_hrs_fte_ze "Total employment (in 1000s)"
replace tot_hrs_fte_ze = tot_hrs_fte_ze / 1e+3

** -----------------------------------------------------------------------------
global mean
foreach v in $zevar {
	global mean $mean m_`v' = `v'
}

global stat_list p50 p90 

foreach stat in $stat_list {
	global `stat'
	foreach v in $zevar {
		global `stat'  $`stat' `stat'_`v' = `v'
	}
}

global cmd_allstat (mean) $mean
foreach stat in $stat_list {
	global cmd_allstat $cmd_allstat (`stat') ${`stat'}
}

** -----------------------------------------------------------------------------


gcollapse (sum) $zevar , by(ZE2010 year)

bys ZE2010: gen distinct_ze = _n==1

gcollapse $cmd_allstat (sum) distinct_ze (count) N = ZE2010

** -- collect stats

foreach var in $zevar {
	global m_`var'_z : di %9.2f m_`var'[1]

	foreach stat in $stat_list {
		global `stat'_`var'_z  : di %9.2f `stat'_`var'[1]
	}
}

global N_z : dis %12.0gc N[1]
global uniq_z : dis %12.0gc distinct_ze[1]
global uniq_z_lab "\# CZ "	

/* __________________________________________________________________________
   ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯ 
   3 ** Creation of the table
   __________________________________________________________________________
   ¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯ */ 
	
cd $outpath
texdoc init TableA1.tex, replace force

tex & \multicolumn{4}{l}{ \textbf{Panel A.} Sector $\times$ CZ-level statistics }  \\ \midrule
tex & \multicolumn{1}{l}{\textbf{\textit{R\&D and exposure variables}}} & \multicolumn{1}{c}{Mean} & \multicolumn{1}{c}{p50} & \multicolumn{1}{c}{p90} \\
tex  \addlinespace \cmidrule(lr){2-2} \cmidrule(lr){3-3} \cmidrule(lr){4-4} \cmidrule(lr){5-5} 
foreach var in $lvar_zenaf_job	 {
	dis "`var'"
	tex & ${`var'} & ${m_`var'_zn} &  ${p50_`var'_zn} &  ${p90_`var'_zn}  \\
}
tex \midrule & \multicolumn{4}{l}{${N}: ${N_zn} --- ${uniq_zn_lab} : ${uniq_zn} }   \\ \midrule \midrule 

tex & \multicolumn{2}{l}{\textbf{Panel B.} CZ-level statistics }  &  & \\ \midrule


foreach var in $zevar {
	dis "`var'"
	tex & ${`var'} & ${m_`var'_z} &  ${p50_`var'_z} &  ${p90_`var'_z} \\ 
}
tex \midrule & \multicolumn{4}{l}{${N}: ${N_z} --- ${uniq_z_lab} : ${uniq_z} }   \\ \midrule 

texdoc close

